/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize


/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////
/*
"Tamby's gears" by Emmanuel Keller aka Tambako - December 2015
License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
Contact: tamby@tambako.ch
*/

const float pi = 3.14159;
const float bs = 0.0015;
const float e = 0.07;
const float speed = 8.0; // was 22.0
const float rc = 0.025;

const float aawidth = 0.9;
const int aasamples = 2;

vec2 rotateVec(vec2 vect, float angle)
{
    vec2 rv;
    rv.x = vect.x*cos(angle) + vect.y*sin(angle);
    rv.y = vect.x*sin(angle) - vect.y*cos(angle);
    return rv;
}

vec3 overlay(vec3 col, float v)
{
   return mix(mix(vec3(0.), col, clamp(v*2., 0., 1.)), vec3(1.), clamp(v*2. - 1., 0., 1.));
}

vec4 gear(vec2 uv, vec2 center, float r, float nb, float t, float rs, float ph)
{
    // Basic contours
	uv-= center + vec2(0., 0.5*(0.55 - (iResolution.x-iResolution.y)/iResolution.x)); 
    float angle = atan(uv.x, uv.y);
    float rot = rs*iGlobalTime;
    float v = length(uv) + r*t*(smoothstep(e, 1.-e, sin(ph + angle*nb + rot)*0.5 + 0.5));    
    float v1 = smoothstep(r, r+bs, v);  
    float v2 = smoothstep(e, 1.-e, cos(ph + angle*nb + rot)*0.5 + 0.5); 
    
    // Metal texture
    vec2 uvr = rotateVec(uv*3.2, rot/nb) - center;
    vec2 uv2 = uv*3.2 - center;
    vec4 txt = texture2D(iChannel0,uvr);
    
    // Metallic reflection gradient
    vec3 grad = vec3(0.2 + .3*smoothstep(-1.0, 0.5, uv2.y+0.5) -0.3*smoothstep(0.12, 0.31, uv2.y+1.1) + 0.6*smoothstep(0.15, 0.57, uv2.y+1.7) + 0.3*smoothstep(0.35, 0.55, uv2.y+1.) - 0.6*smoothstep(0.6, 0.95, uv2.y+1.1));
    vec3 i = mix(mix(grad, txt.rgb, 0.28 + grad.x*0.2), vec3(1.), v1);
    float v3 = 0.3 + 0.5*v2*smoothstep(r+0.005, r-0.005, v)*smoothstep(r-0.008, r-0.004, v) + 0.2*smoothstep(r, r-bs, v+0.008); 
    i = mix(overlay(i, v3), vec3(1.), v1);
    
    // Shadow
    float vs = length(uv + (0.02, 0.02)) + 0.3*r*t*(smoothstep(e, 1.-e, sin(ph + atan(uv.x + 0.02, uv.y + 0.02)*nb + rot)*0.5 + 0.5));  
    float sh = mix(1., 1. - 0.5*smoothstep(r, r-0.05, vs-0.008), v1);
    
    return vec4(i*vec3(sh), v1);
}

vec3 gears(vec2 fragCoord, vec2 of)
{
    vec2 uv = (fragCoord.xy + of) / iResolution.xx;
    
    // We have five gears
    vec4 v = gear(uv, vec2(0.22, 0.34), 0.2, 20., 0.15, speed, 0.);
    v*= gear(uv, vec2(0.498, 0.34), 0.1, 9., 0.3, -speed, 1.9);
    v*= gear(uv, vec2(0.777, 0.34), 0.2, 20., 0.15, speed, 2.5);
    v*= gear(uv, vec2(0.38, 0.14), 0.08, 7., 0.35, -speed, -0.8);
    v*= gear(uv, vec2(0.64, 0.04), 0.15, 14., 0.22, -speed, 2.2);
    
    // Background
    float v1 = v.a;
    vec3 bg = mix(vec3(1.0), mix(vec3(1., 0.95, 0.9), 0.4+texture2D(iChannel1,uv*4.).rgb, 0.5), clamp(v1, 0., 1.));

    return v.rgb*bg;    
}

void mainImage(out vec4 fragColor, in vec2 fragCoord)
{  
    // Antialiasing
    vec3 vs = vec3(0.);
    for (int j=0;j<aasamples ;j++)
    {
       float oy = float(j)*aawidth/max(float(aasamples-1), 1.);
       for (int i=0;i<aasamples ;i++)
       {
          float ox = float(i)*aawidth/max(float(aasamples-1), 1.);
          vs+= gears(fragCoord, vec2(ox, oy));
       }
    }

    fragColor.rgb = vs/vec3(aasamples*aasamples);
    fragColor.a = 1.0;    

}

void main ( void )
{ mainImage ( gl_FragColor, gl_FragCoord.xy );
}